;                     "" 
;********************************************************************************
           LIST p=12F629                 ;   : PIC12F629.
           __CONFIG 3F94H                ;   : 
                                         ; , WDT ,   
                                         ; , PWRT  (11111110010100).
;================================================================================
;               .
;================================================================================
OptionR    equ            01h            ;  Option - 1
Status     equ            03h            ;  Status
GPIO       equ            05h            ;  -
TRISIO     equ            05h            ;  TrisIO - 1
IntCon     equ            0Bh            ;  IntCon
PIR1       equ            0Ch            ;     EEPROM
VPU        equ            15h            ; .    -  1
CMCON      equ            19h            ;   
VRCON      equ            19h            ;    -  1
EEdata     equ            1Ah            ; EEPROM  -  1
EECon1     equ            1Ch            ; EECON1 -  1
EEAdr      equ            1Bh            ; EEPROM  -  1
EECon2     equ            1Dh            ; EECON2 -  1
;================================================================================
;       .
;================================================================================
SecH       equ            20h            ;  
SecZ1      equ            21h            ;    
SecZ2      equ            22h            ;    
Mode       equ            23h            ;   
Z1Temp     equ            24h            ;  
Z2Temp     equ            25h            ;   (EEPROM   )
SecZ3      equ            26h            ;    ()
Z3Temp     equ            27h            ;  
Z4Temp     equ            28h            ;   (  EEPROM)
SecZ5      equ            29h            ;     ( )
SecZ6      equ            2Ah            ;     ( )
Z5Prom     equ            2Bh
SWIT1      equ            2Ch            ;    
SWIT2      equ            2Dh            ; ---/---
;================================================================================
;       
;   ,      ( 
;   ).
;================================================================================
F          equ            1              ;    ,  
                                         ;   .
W          equ            0              ;    
;================================================================================
;     .
; (    ).
;================================================================================
RP0        equ            5              ;  5-   STATUS
                                         ;  RP0.
COUT       equ            6              ;  6   CMCON  COUT
Z          equ            2              ;  2   Status  Z
EEIF       equ            7              ;  7   PIR1  EEIF
GIE        equ            7              ;  7   IntCon  GIE
;---------------------------------------------------------------------------------
           org            2100h          ;   EEPROM  .
           DE             15h,1Dh,05h,21h,03h   ;      .0, .1, .2 
                                         ;  0h, 0h, 64h (.100) . 
;================================================================================
;     .
;================================================================================
           org            0              ;   
           goto           START          ;     START.
;********************************************************************************
;------------------------    -----------------------------
;********************************************************************************
;  .
;--------------------------------------------------------------------------------
START      clrf           IntCon         ;   .           
           movlw          .20            ;   
           movwf          CMCON          ;  (.20 = 00010100)           
           bsf            Status,RP0     ;   1.
           movlw          .30            ; GP1,GP2,GP3,GP4   , (.30 = 011110)
           movwf          TRISIO         ;  -  .           
           movlw          .127           ;   
           movwf          OptionR        ;  -  . (.127 = 01111111)          
           movlw          .20            ;      GP4, GP2
           movwf          VPU            ; (.20 = 00010100)          
           movlw          .138           ;   
           movwf          VRCON          ;  (.138 = 10001010)                                                  
           bcf            Status,RP0     ;   0.          
           bsf            GPIO,5         ;   1            
           bcf            GPIO,0         ;   0                        
;--------------------------------------------------------------------------------
;    EEPROM
;--------------------------------------------------------------------------------
           bsf            Status,RP0     ;   1
           movlw          .1             ;    W  0h.
           movwf          EEAdr          ;  0h   W   EEAdr.
           bsf            EECon1,0       ;  .
WR1        btfsc          EECon1,0
           goto           WR1
           movf           EEdata,W       ;     EEPROM   0h   W.
           bcf            Status,RP0     ;   0.
           movwf          Z1Temp         ;    
           bsf            Status,RP0     ;   1
           movlw          .2             ;    W  1h.
           movwf          EEAdr          ;  0h   W   EEAdr.
           bsf            EECon1,0       ;  .
WR2        btfsc          EECon1,0
           goto           WR2
           movf           EEdata,W       ;     EEPROM   01h   W.
           bcf            Status,RP0     ;   0.
           movwf          Z2Temp         ;    
;.........................................................................................
           bsf            Status,RP0     ;   1
           movlw          .3             ;    W  3h.
           movwf          EEAdr          ;  3h   W   EEAdr.
           bsf            EECon1,0       ;  .
WR3        btfsc          EECon1,0
           goto           WR3
           movf           EEdata,W       ;     EEPROM   0h   W.
           bcf            Status,RP0     ;   0.
           movwf          Z3Temp         ;    
           bsf            Status,RP0     ;   1
           movlw          .4             ;    W  4h.
           movwf          EEAdr          ;  4h   W   EEAdr.
           bsf            EECon1,0       ;  .
WR4        btfsc          EECon1,0
           goto           WR4
           movf           EEdata,W       ;     EEPROM   01h   W.
           bcf            Status,RP0     ;   0.
           movwf          Z4Temp         ;                                                                               
;--------------------------------------------------------------------------------
;           
;--------------------------------------------------------------------------------
AVTO       movlw          .1            ; 255
           movwf          SWIT1
           movlw          .54             ; 90
           movwf          SWIT2
AVTO1      btfss          GPIO,2          ; ss
           goto           MODE2
           movlw          .2
           movwf          Mode
           goto           NORM
MODE2      decfsz         Mode,F
           goto           NORM
           goto           CIKL
;--------------------------------------------------------------------------------
;      
;--------------------------------------------------------------------------------        
NORM       movlw          .249           ;    SecH
           movwf          SecH           ;  249.
           movf           Z1Temp,W       ;     EEPROM ( )
           movwf          SecZ1
           movf           Z2Temp,W
           movwf          SecZ2
           movf           Z3Temp,W       ;     EEPROM ( )
           movwf          SecZ5
           movf           Z4Temp,W
           movwf          SecZ6             
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------
CYCLE      btfss          GPIO,3         ;   0,   (ss)
                                         ;  CYCLE
           goto           CYCLE          ;  1 -   .
;--------------------------------------------------------------------------------
;  2   
;--------------------------------------------------------------------------------
Metka1     btfsc          GPIO,3         ;   1    ( c sc  ss)
                                         ; Metka1
           goto           Metka1         ;  0    
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------         
           movf           SWIT2,W
           sublw          .0
           btfsc          Status,Z
           goto           Delay
           btfss          CMCON,COUT     ;    .   14, (ss)
           goto           DelayA         ;   ,   14,  .
           decfsz         SWIT1,F
           goto           DelayA
           decfsz         SWIT2,F
           goto           DelayA
           goto           Delay
DelayA     nop
           nop
           nop
           decfsz         SecZ5,F        ;    .
           goto           DelayA
           decfsz         SecZ6,F
           goto           DelayA
           bcf            GPIO,5         ;    
PAUSE_1    nop
           nop
           nop
           decfsz         SecH,F         ; ""   
           goto           PAUSE_1        ;  .
           bsf            GPIO,5
           goto           AVTO1
;--------------------------------------------------------------------------------
;    
;--------------------------------------------------------------------------------
Delay      nop
           nop
           nop
           decfsz         SecZ1,F        ;    .
           goto           Delay
           decfsz         SecZ2,F
           goto           Delay
           bcf            GPIO,5        
PAUSE_3    nop
           nop
           nop
           decfsz         SecH,F         ; ""   
           goto           PAUSE_3        ;  .
           bsf            GPIO,5
           btfss          GPIO,2         
           goto           CIKL
           goto           AVTO1
;********************************************************************************
;                            2  ( )
;********************************************************************************
CIKL       movlw          .8
           movwf          SecZ6
WIDR       movlw          .2
           movwf          SecZ5
WID        bsf            GPIO,0         ;  
           movlw          .153
           movwf          SecZ1
           movlw          .134
           movwf          SecZ2
           movlw          .2
           movwf          SecZ3
           decfsz         SecZ1,F
           goto           $-1
           decfsz         SecZ2,F
           goto           $-3
           decfsz         SecZ3,F
           goto           $-5
           decfsz         SecZ5,F
           goto           $+2
           goto           WIDDE
           bcf            GPIO,0         ;  
           movlw          .119
           movwf          SecZ1
           movlw          .8
           movwf          SecZ2
           movlw          .3
           movwf          SecZ3
           decfsz         SecZ1,F
           goto           $-1
           decfsz         SecZ2,F
           goto           $-3
           decfsz         SecZ3,F
           goto           $-5
           goto           WID
WIDDE      bcf            GPIO,0         ;  
           movlw          .173
           movwf          SecZ1
           movlw          .19
           movwf          SecZ2
           movlw          .6
           movwf          SecZ3
           decfsz         SecZ1,F
           goto           $-1
           decfsz         SecZ2,F
           goto           $-3
           decfsz         SecZ3,F
           goto           $-5
           btfss          GPIO,2
           goto           READY
           decfsz         SecZ6,F
           goto           WIDR
           movlw          .23
           movwf          Z3Temp
WIDR2      movlw          .2
           movwf          SecZ6
WID2       bsf            GPIO,0         ;  
           movlw          .30            ; 30
           movwf          SecZ3
;--------------------------------------------------------------------------------
;      
;--------------------------------------------------------------------------------        
CIKL1      movlw          .249           ;    SecH
           movwf          SecH           ;  249.
           movf           Z1Temp,W       ;     EEPROM ( )
           movwf          SecZ1
           movf           Z2Temp,W
           movwf          SecZ2           
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------
CIKL2      btfss          GPIO,3         ;   0,  
                                         ;
           goto           CIKL2          ;  1 -   .
;--------------------------------------------------------------------------------
;  2   
;--------------------------------------------------------------------------------
CIKL3      btfsc          GPIO,3         ;   1   ( c sc  ss)
                                         ;
           goto           CIKL3          ;  0    
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------        
DelayB     btfss          GPIO,2
           goto           READY
           nop
           decfsz         SecZ1,F        ;    .
           goto           DelayB
           decfsz         SecZ2,F
           goto           DelayB
           bcf            GPIO,5         ;    
CIKL4      nop
           nop
           nop
           decfsz         SecH,F         ; ""   
           goto           CIKL4          ;  .
           bsf            GPIO,5
;-------------------------------------------------------------------------------           
           decfsz         SecZ3,F
           goto           CIKL1
           decfsz         SecZ6,F
           goto           $+2
           goto           WIDDE3
WIDDE2     bcf            GPIO,0         ;  
           movlw          .40            ; 40
           movwf          SecZ5
;--------------------------------------------------------------------------------
;      
;--------------------------------------------------------------------------------        
CIKL5      movlw          .249           ;    SecH
           movwf          SecH           ;  249.
           movf           Z1Temp,W       ;     EEPROM ( )
           movwf          SecZ1
           movf           Z2Temp,W
           movwf          SecZ2           
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------
CIKL6      btfss          GPIO,3         ;   0,  
                                         ;
           goto           CIKL6          ;  1 -   .
;--------------------------------------------------------------------------------
;  2   
;--------------------------------------------------------------------------------
CIKL7      btfsc          GPIO,3         ;   1   ( c sc  ss)
                                         ;
           goto           CIKL7          ;  0    
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------        
DelayC     btfss          GPIO,2
           goto           READY
           nop
           decfsz         SecZ1,F        ;    .
           goto           DelayC
           decfsz         SecZ2,F
           goto           DelayC
           bcf            GPIO,5         ;    
CIKL8      nop
           nop
           nop
           decfsz         SecH,F         ; ""   
           goto           CIKL8          ;  .
           bsf            GPIO,5
;----------------------------------------------------------------------------------
           decfsz         SecZ5,F
           goto           CIKL5
           goto           WID2
WIDDE3     bcf            GPIO,0         ;  
           movlw          .100           ; 100
           movwf          Mode
;--------------------------------------------------------------------------------
;      
;--------------------------------------------------------------------------------        
CIKL9      movlw          .249           ;    SecH
           movwf          SecH           ;  249.
           movf           Z1Temp,W       ;     EEPROM ( )
           movwf          SecZ1
           movf           Z2Temp,W
           movwf          SecZ2           
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------
CIKL10     btfss          GPIO,3         ;   0,  
                                         ;
           goto           CIKL10         ;  1 -   .
;--------------------------------------------------------------------------------
;  2   
;--------------------------------------------------------------------------------
CIKL11     btfsc          GPIO,3         ;   1   ( c sc  ss)
                                         ;
           goto           CIKL11         ;  0    
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------        
DelayD     btfss          GPIO,2
           goto           READY
           nop
           decfsz         SecZ1,F        ;    .
           goto           DelayD
           decfsz         SecZ2,F
           goto           DelayD
           bcf            GPIO,5         ;    
CIKL12     nop
           nop
           nop
           decfsz         SecH,F         ; ""   
           goto           CIKL12         ;  .
           bsf            GPIO,5
;----------------------------------------------------------------------------------
           decfsz         Mode,F
           goto           CIKL9
           decfsz         Z3Temp                      
           goto           WIDR2
           goto           CIKL
;********************************************************************************
;                           3  
;********************************************************************************
READY      movlw          .1 
           movwf          SWIT1           
           movlw          .100           ; 229
           movwf          SecZ1
           movlw          .1             ; 2
           movwf          SecZ2
REAID1     movlw          .3
           movwf          SecZ6
REAI2      bsf            GPIO,0         ;  
           movlw          .30
           movwf          Mode
           goto           REA1
REAI1      bcf            GPIO,0         ;  
           movlw          .40
           movwf          Z1Temp
           goto           REA1
REAID      bcf            GPIO,0         ;  
           btfss          GPIO,2
           goto           MANUAL
           movlw          .100
           movwf          Z2Temp
;--------------------------------------------------------------------------------
;    
;--------------------------------------------------------------------------------        
REA1       movlw          .249           ;    SecH
           movwf          SecH           ;  249.
           movlw          .100           ;    SecZ1
           movwf          SecZ3          ;  .71
           movlw          .1             ;    SecZ2
           movwf          SecZ5          ;  .3            
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------
REA2       btfss          GPIO,3         ;   0,  
                                         ;
           goto           REA2           ;  1 -   .
;--------------------------------------------------------------------------------
;  2   
;--------------------------------------------------------------------------------
REA3       btfsc          GPIO,3         ;   1   ( c sc  ss)
                                         ;
           goto           REA3           ;  0    
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------
DelayR     nop
           nop
           nop
           decfsz         SecZ3,F        ;    .
           goto           DelayR
           decfsz         SecZ5,F
           goto           DelayR
           bcf            GPIO,5         ;    
REA4       nop
           nop
           nop
           decfsz         SecH,F         ; ""   
           goto           REA4           ;  .
           bsf            GPIO,5
;--------------------------------------------------------------------------------
           movf           Mode,W
           sublw          .0
           btfsc          Status,Z
           goto           REA5
           decfsz         Mode,F         ;    
           goto           REA1
           decfsz         SecZ6,F        ;   
           goto           REAI1
           goto           REAID                      
REA5       movf           Z1Temp,W
           sublw          .0
           btfsc          Status,Z
           goto           REA6
           decfsz         Z1Temp,F       ;    
           goto           REA1
           goto           REAI2
REA6       decfsz         Z2Temp,F       ;     
           goto           REA1
           decfsz         SecZ1,F        ;   
           goto           REAID1
           decfsz         SecZ2,F        ;   
           goto           REAID1
           goto           START
;********************************************************************************
;                           2  
;********************************************************************************
MANUAL     bsf            GPIO,0         ;   " "
           movlw          .1             ;    SecZ1
           movwf          SecZ1          ;  .1
           movlw          .0             ;    SecZ2
           movwf          SecZ2          ;  .0
           movf           SecZ1,W        ;    SecZ1 
           movwf          Z1Temp         ;  
           movf           SecZ2,W        ;    SecZ2 
           movwf          Z2Temp         ;             
;--------------------------------------------------------------------------------
;    ()
;--------------------------------------------------------------------------------
CIRCLE     btfss          GPIO,4         ;   ss  sc
           goto           CALIB
           btfsc          GPIO,2         ;   sc  ss
           goto           Metka5          
;--------------------------------------------------------------------------------
;     ( )
;--------------------------------------------------------------------------------                 
           bcf            Status,Z
           incf           SecZ1,F
           btfsc          Status,Z
           goto           Metka2                              
           movf           SecZ1,W        ;    SecZ1 
           movwf          Z1Temp         ;   
           movwf          Z3Temp
           goto           Metka3
Metka2     movf           SecZ1,W        ;    SecZ1 
           movwf          Z1Temp         ;   
           movwf          Z3Temp 
           incf           SecZ2,F
Metka3     movf           SecZ2,W        ;    SecZ2 c
           movwf          Z2Temp         ;   
           movwf          Z4Temp
           bcf            Status,Z
           sublw          .5             ;    SecZ2
           btfss          Status,Z
           goto           Metka5
           bcf            Status,Z
           movf           Z1Temp,W
           sublw          .129           ;    SecZ1
           btfsc          Status,Z
           goto           MANUAL
;-------------------------------------------------------------------------------
;     
;-------------------------------------------------------------------------------
Metka5     btfss          GPIO,3         ;   0,  
                                         ;  Metka5
           goto           Metka5          ;  1 -   .
;--------------------------------------------------------------------------------
;  2   
;--------------------------------------------------------------------------------
Metka6     btfsc          GPIO,3         ;   1    (  sc) 
                                         ; Metka1
           goto           Metka6         ;  0    
;--------------------------------------------------------------------------------
;     
;--------------------------------------------------------------------------------
           movlw          .249           ;    SecH
           movwf          SecH           ;  249.           
           btfsc          CMCON,COUT     ;    .   14,
           goto           OFF            ;   ,   14,  .
Delay2     nop
           nop
           nop
           decfsz         SecZ1,F        ;    .
           goto           Delay2
           movf           SecZ2,W        ;  
           sublw          .0             ; 
           btfsc          Status,Z       ; 
           goto           GO1            ;    ( - )
           decfsz         SecZ2,F
           goto           Delay2
GO1        bcf            GPIO,5
PAUSE_2    nop
           nop
           nop
           decfsz         SecH,F         ; ""   
           goto           PAUSE_2        ;  .
           bsf            GPIO,5
           movf           Z1Temp,W
           movwf          SecZ1
           movf           Z2Temp,W
           movwf          SecZ2
           goto           CIRCLE
;--------------------------------------------------------------------------------
;          ,    
;--------------------------------------------------------------------------------
OFF        movlw          .30            ;    SecZ1
           movwf          SWIT1
OFF1       bcf            GPIO,0
           movlw          .255           ;    SecZ1
           movwf          SecZ1          ;  .255
           movlw          .255           ;    SecZ2
           movwf          SecZ2          ;  .255
           movlw          .3             ;    SecZ3
           movwf          SecZ3          ;  .1
Delay3     nop
           nop
           nop
           decfsz         SecZ1,F        ;    .
           goto           Delay3
           decfsz         SecZ2,F
           goto           Delay3
           decfsz         SecZ3,F
           goto           Delay3
           bsf            GPIO,0
           movlw          .255           ;    SecZ1
           movwf          SecZ1          ;  .255
           movlw          .255           ;    SecZ2
           movwf          SecZ2          ;  .255
           movlw          .3             ;    SecZ3
           movwf          SecZ3          ;  .1
Delay4     nop
           nop
           nop
           decfsz         SecZ1,F        ;    .
           goto           Delay4
           decfsz         SecZ2,F
           goto           Delay4
           decfsz         SecZ3,F
           goto           Delay4
           btfss          GPIO,2
           goto           START
           decfsz         SWIT1,F
           goto           OFF1
           goto           START
;********************************************************************************
;                                 
;********************************************************************************
CALIB      bcf            GPIO,0         ;   0  
           btfsc          PIR1,EEIF
           goto           MAX
;--------------------------------------------------------------------------------
;     
;-------------------------------------------------------------------------------- 
           bcf            IntCon,GIE     ;             
           bsf            Status,RP0     ;   1
           movlw          .1             ;    W  0h.
           movwf          EEAdr          ;  0h   W   EEAdr.
           movf           Z1Temp,W       ;     
           movwf          EEdata         ;      EEPROM           
           bsf            EECon1,2       ;             
           movlw          055h
           movwf          EECon2
           movlw          0AAh
           movwf          EECon2
           bsf            EECon1,1
REC1       btfsc          EECon1,1
           goto           REC1 
           bcf            EECon1,2       ;   
           bcf            Status,RP0     ;   0        
;.................................................................................
           bcf            IntCon,GIE     ;    
           bsf            Status,RP0     ;   1
           movlw          .2             ;    W  1h.
           movwf          EEAdr          ;  1h   W   EEAdr.
           movf           Z2Temp,W       ;     
           movwf          EEdata         ;      EEPROM           
           bsf            EECon1,2       ;             
           movlw          055h
           movwf          EECon2
           movlw          0AAh
           movwf          EECon2
           bsf            EECon1,1
REC2       btfsc          EECon1,1
           goto           REC2
           bcf            EECon1,2       ;   
           bcf            Status,RP0     ;    0
           btfss          PIR1,EEIF
           goto           START            
           goto           DONE           ;      
;-----------------------------------------------------------------------------------------
;     
;-----------------------------------------------------------------------------------------
MAX        bcf            IntCon,GIE     ;   
           bcf            PIR1,EEIF      ;    
           bsf            Status,RP0     ;   1
           movlw          .3             ;    W  3h.
           movwf          EEAdr          ;  3h   W   EEAdr.
           movf           Z3Temp,W       ;     
           movwf          EEdata         ;      EEPROM           
           bsf            EECon1,2       ;             
           movlw          055h
           movwf          EECon2
           movlw          0AAh
           movwf          EECon2
           bsf            EECon1,1
REC3       btfsc          EECon1,1
           goto           REC3
           bcf            EECon1,2       ;   
           bcf            Status,RP0     ;   0
;----------------------------------------------------------------------------------------           
           bcf            IntCon,GIE     ;    
           bsf            Status,RP0     ;   1         
           movlw          .4             ;    W  4h.
           movwf          EEAdr          ;  4h   W   EEAdr.
           movf           Z4Temp,W       ;     
           movwf          EEdata         ;      EEPROM           
           bsf            EECon1,2       ;             
           movlw          055h
           movwf          EECon2
           movlw          0AAh
           movwf          EECon2
           bsf            EECon1,1
REC4       btfsc          EECon1,1
           goto           REC4
           bcf            EECon1,2       ;   
           bcf            Status,RP0     ;    0
           btfss          PIR1,EEIF
           goto           START 
           bcf            PIR1,EEIF      ;    
;---------------------------------------------------------------------------------------
;    .    
;---------------------------------------------------------------------------------------
DONE       bcf            GPIO,0         ;   0  
           btfss          GPIO,2         ;    
           goto           START
           movlw          .37            ;    SecZ1
           movwf          SecZ1          ;  .37
           movlw          .52            ;    SecZ2
           movwf          SecZ2          ;  .52
           movlw          .2             ;    SecZ3
           movwf          SecZ3          ;  .1
Delay5     nop
           nop
           nop
           decfsz         SecZ1,F        ;    .
           goto           Delay5
           decfsz         SecZ2,F
           goto           Delay5
           decfsz         SecZ3,F
           goto           Delay5
           bsf            GPIO,0
           movlw          .37            ;    SecZ1
           movwf          SecZ1          ;  .37
           movlw          .52            ;    SecZ2
           movwf          SecZ2          ;  .52
           movlw          .2             ;    SecZ3
           movwf          SecZ3          ;  .1
Delay6     nop
           nop
           nop
           decfsz         SecZ1,F        ;    .
           goto           Delay6
           decfsz         SecZ2,F
           goto           Delay6
           decfsz         SecZ3,F
           goto           Delay6
           goto           DONE                                                 
;================================================================================
           end                           ;  .

